<?php 
  include("../../private/conexion.php");

  if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');
  }
  if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers:        {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

    exit(0);
  }
  header("Access-Control-Allow-Origin: *");

  if (!empty($_GET['id_reservacion'])) {
    $_id_reservacion = $_GET['id_reservacion'];

    $nombre_archivo = $_id_reservacion . '_' . uniqid() . '.pdf';
    $rupdate_nombre = $mysqli->query("UPDATE `bloqueos_reservaciones` SET `pdf_confirmacion`='$nombre_archivo' WHERE id=$_id_reservacion");

    $rget_reservacion = $mysqli->query("SELECT * FROM bloqueos_reservaciones WHERE id=$_id_reservacion");
    if ($rget_reservacion)
    {
      while($array = $rget_reservacion->fetch_object())
      {
        $id_agencia          = $array->id_agencia;
        $id_agente           = $array->id_agente;
        $id_hotel            = $array->id_hotel;
        $id_bloqueo          = $array->id_bloqueo;
        $titular             = $array->titular;
        $folio               = $array->folio;
        $total               = $array->total;
        $habitaciones        = $array->habitaciones;
        $dia_extra_inicio    = $array->dia_extra_inicio;
        $dia_extra_fin       = $array->dia_extra_fin;
        $total_dias_extra    = $array->total_dias_extra;
        $status_dias_extra   = $array->status_dias_extra;
        $esComisionable      = $array->esComisionable;
        $porcentaje_comision = $array->porcentaje_comision;
        $total_habitaciones  = $array->total_habitaciones;
        $pdf_confirmacion    = $array->pdf_confirmacion;
        $pdf_voucher         = $array->pdf_voucher;
        $date_register       = $array->date_register;
      }
    }

    $rget_bloqueo = $mysqli->query("SELECT * FROM bloqueos WHERE id=$id_bloqueo");
    if ($rget_bloqueo)
    {
      if (mysqli_num_rows($rget_bloqueo)>0) {
        while($array = $rget_bloqueo->fetch_object())
        {
          $bloqueo_fecha_inicial       = $array->fecha_inicial;
          $bloqueo_fecha_final         = $array->fecha_final;
          $bloqueo_sgl                 = $array->sgl;
          $bloqueo_sgl_habitaciones    = $array->sgl_habitaciones;
          $bloqueo_sgl_permitidos      = $array->sgl_permitidos;
          $bloqueo_dbl                 = $array->dbl;
          $bloqueo_dbl_habitaciones    = $array->dbl_habitaciones;
          $bloqueo_dbl_permitidos      = $array->dbl_permitidos;
          $bloqueo_tpl                 = $array->tpl;
          $bloqueo_tpl_habitaciones    = $array->tpl_habitaciones;
          $bloqueo_tpl_permitidos      = $array->tpl_permitidos;
          $bloqueo_mnr                 = $array->mnr;
          $bloqueo_mnr_habitaciones    = $array->mnr_habitaciones;
          $bloqueo_mnr_permitidos      = $array->mnr_permitidos;
          $bloqueo_cpl                 = $array->cpl;
          $bloqueo_total_habitaciones  = $array->total_habitaciones;
          $bloqueo_nombre_habitacion   = $array->nombre_habitacion;
          $bloqueo_esComisionable      = $array->esComisionable;
          $bloqueo_porcentaje_comision = $array->porcentaje_comision;
          $bloqueo_date_register       = $array->date_register;
        }
      }else{
        $bloqueo_fecha_inicial       = "No se encontro.";
        $bloqueo_fecha_final         = "No se encontro.";
        $bloqueo_sgl                 = "No se encontro.";
        $bloqueo_sgl_habitaciones    = "No se encontro.";
        $bloqueo_sgl_permitidos      = "No se encontro.";
        $bloqueo_dbl                 = "No se encontro.";
        $bloqueo_dbl_habitaciones    = "No se encontro.";
        $bloqueo_dbl_permitidos      = "No se encontro.";
        $bloqueo_tpl                 = "No se encontro.";
        $bloqueo_tpl_habitaciones    = "No se encontro.";
        $bloqueo_tpl_permitidos      = "No se encontro.";
        $bloqueo_mnr                 = "No se encontro.";
        $bloqueo_mnr_habitaciones    = "No se encontro.";
        $bloqueo_mnr_permitidos      = "No se encontro.";
        $bloqueo_cpl                 = "No se encontro.";
        $bloqueo_total_habitaciones  = "No se encontro.";
        $bloqueo_nombre_habitacion   = "No se encontro.";
        $bloqueo_esComisionable      = "No se encontro.";
        $bloqueo_porcentaje_comision = "No se encontro.";
        $bloqueo_date_register       = "No se encontro.";
      }
    }

    $rget_hotel = $mysqli->query("SELECT * FROM bloqueos_hoteles WHERE id=$id_hotel");
    if ($rget_hotel)
    {
      if (mysqli_num_rows($rget_hotel)>0) {
        while($array = $rget_hotel->fetch_object())
        {
          $hotel_ubicacion            = $array->ubicacion;
          $hotel_nombre               = $array->nombre;
          $hotel_precio_inicial_noche = $array->precio_inicial_noche;
          $hotel_descripcion          = $array->descripcion;
          $hotel_imagen               = $array->imagen;
          $hotel_portada              = $array->portada;
          $hotel_logo                 = $array->logo;
          $hotel_date_register        = $array->date_register;
        }
      }else{
        $hotel_ubicacion            = "No se encontro.";
        $hotel_nombre               = "No se encontro.";
        $hotel_precio_inicial_noche = "No se encontro.";
        $hotel_descripcion          = "No se encontro.";
        $hotel_imagen               = "No se encontro.";
        $hotel_portada              = "No se encontro.";
        $hotel_logo                 = "No se encontro.";
        $hotel_date_register        = "No se encontro.";
      }
    }

    $rget_agencia = $mysqli->query("SELECT * FROM agencias WHERE id=$id_agencia");
    if ($rget_agencia)
    {
      if (mysqli_num_rows($rget_agencia)>0) {
        while($array = $rget_agencia->fetch_object())
        {
          $nombre_agencia = $array->nombre_agencia;
        }
      }else{
        $nombre_agencia = "No se encontro.";
      }
    }

    $total_sgl = 0;
    $total_dbl = 0;
    $total_tpl = 0;
    $total_cpl = 0;

    $total_menores_sgl = 0;
    $total_menores_dbl = 0;
    $total_menores_tpl = 0;
    $total_menores_cpl = 0;

    $total_adultos_sgl = 0;
    $total_adultos_dbl = 0;
    $total_adultos_tpl = 0;
    $total_adultos_cpl = 0;

    $total_menores = 0;
    $total_Adultos = 0;

    $rget_reservacion_detalles = $mysqli->query("SELECT * FROM bloqueos_reservaciones_detalles WHERE id_reserva=$_id_reservacion");
    if ($rget_reservacion_detalles)
    {
      if (mysqli_num_rows($rget_reservacion_detalles)>0) {
        while($array = $rget_reservacion_detalles->fetch_object())
        {
          $detalles_habitacion     = $array->habitacion;
          $detalles_precio         = $array->precio;
          $detalles_permitidos     = $array->permitidos;
          $detalles_adultos        = $array->adultos;
          $detalles_menores        = $array->menores;
          $detalles_total_personas = $array->total_personas;

          $total_menores+= $detalles_menores;
          $total_adultos+= $detalles_adultos;

          if (strpos($detalles_habitacion, 'SGL') !== false) {
            $total_sgl++;
            $total_menores_sgl+= $detalles_menores;
            $total_adultos_sgl+= $detalles_adultos;
          }else if (strpos($detalles_habitacion, 'DBL') !== false) {
            $total_dbl++;
            $total_menores_dbl+= $detalles_menores;
            $total_adultos_dbl+= $detalles_adultos;
          }else if (strpos($detalles_habitacion, 'TPL') !== false) {
            $total_tpl++;
            $total_menores_tpl+= $detalles_menores;
            $total_adultos_tpl+= $detalles_adultos;
          }else if (strpos($detalles_habitacion, 'CPL') !== false) {
            $total_cpl++;
            $total_menores_cpl+= $detalles_menores;
            $total_adultos_cpl+= $detalles_adultos;
          }

        }
      }
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>PDF Confirmación reserva: <?php echo $_id_reservacion; ?></title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="css.css">
</head>
<body onload="imprimirTicket()">
  <section>
    <article class="text-center">
      <span>Confirmación de reservación</span>
    </article>
  </section>
  <section class="header-pdf">
    <article class="container-flex">
      <div>
        <img class="logo-pdf" src="./logo-quality.png" alt="Logo Qualitu Service">
      </div>

      <div class="container-qr">
        <span class="">Qualityservice.com.mx</span>
        <span class="small-text"><?php echo date('d-m-Y'); ?></span>
      </div>
    </article>
  </section>


  <section>
    <article>
      <h1 class="titulo">Estimado compañero de agencia test</h1>
      <p class="texto">
        Por medio de la presente le envio un cordial saludo y le comunico la informacion de la reservacion que gracias a su invaluable preferencia hemos confirmado. Los datos son los siguientes:
      </p>
    </article>

    <article class="secion">
      <div class="_1">
        <!-- Titular -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Titular:
            </span>

            <div class="valor">
              <?php echo $titular; ?>
            </div>
          </div>
        </div>

        <!-- Hotel -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Hotel:
            </span>

            <div class="valor">
              <?php echo $hotel_nombre; ?>
            </div>
          </div>
        </div>

        <!-- Plan -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Plan:
            </span>

            <div class="valor">
              Todo incluido
            </div>
          </div>
        </div>

        <!-- Agencia -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Agencia:
            </span>

            <div class="valor">
              <?php echo $nombre_agencia; ?>
            </div>
          </div>
        </div>

        <!-- Agente -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Agente:
            </span>

            <div class="valor">
              Agente test
            </div>
          </div>
        </div>
      </div>

      <div class="_2">
        <!-- Fecha -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              
            </span>

            <div class="valor">
              29 - Jun -2023
            </div>
          </div>
        </div>


        <!-- Folio -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Folio:
            </span>

            <div class="valor">
              <?php echo $folio; ?>
            </div>
          </div>
        </div>


        <!-- Inn -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Llegada:
            </span>

            <div class="valor">
              <?php echo $bloqueo_fecha_inicial; ?>
            </div>
          </div>
        </div>

        <!-- Out -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              Salida:
            </span>

            <div class="valor">
              <?php echo $bloqueo_fecha_final; ?>
            </div>
          </div>
        </div>
      </div>
    </article>

    <article class="secion">
      <div class="_1">
        <!-- Titular -->
        <div class="d-block">
          <div>
            <span class="campo-large">
              Comentarios:
            </span>

            <div class="valor-large">
              Ninguno
            </div>
          </div>
        </div>
      </div>

      <div class="_2">
        <!-- Fecha -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo-small">
              Fecha Limite:
            </span>

            <div class="valor">
              <?php echo $bloqueo_fecha_final; ?>
            </div>
          </div>
        </div>


        <!-- Folio -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo-small">
              Total venta:
            </span>

            <div class="valor">
              $<?php echo $total; ?>
            </div>
          </div>
        </div>


        <!-- Inn -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo-small">
              Comisión:
            </span>

            <div class="valor">
              <?php echo $porcentaje_comision; ?>%
              <br> $<?php echo number_format(($total*$porcentaje_comision)/100,2); ?>
            </div>
          </div>
        </div>

        <!-- Out -->
        <div class="d-block">
          <div class="container-flex">
            <span class="campo">
              A pagar
            </span>

            <div class="valor">
              $<?php echo number_format($total + ($total*$porcentaje_comision)/100,2); ?>
            </div>
          </div>
        </div>
      </div>
    </article>


    <article>
      <table class="table-1">
        <tr>
          <th class="titulo-table">ID Tarifa</th>
          <th class="titulo-table">SGL</th>
          <th class="titulo-table">DBL</th>
          <th class="titulo-table">TPL</th>
          <th class="titulo-table">CPL</th>
<!--           <th class="titulo-table">EXT</th>
          <th class="titulo-table">MNR</th> -->
        </tr>

        <tr>
          <td class="desc-table">PARTIDA</td>
          <td class="desc-table">$<?php echo $bloqueo_sgl; ?></td>
          <td class="desc-table">$<?php echo $bloqueo_dbl; ?></td>
          <td class="desc-table">$<?php echo $bloqueo_tpl; ?></td>
          <td class="desc-table">$<?php echo $bloqueo_cpl; ?></td>
          <!-- <td class="desc-table">$0</td>
          <td class="desc-table">$0</td> -->
        </tr>
            </table>
    </article>


    <article style="margin-top: 24px;">
      <div class="_1-1">
        <table class="table-1">
          <tr>
            <th class="titulo-table"></th>
            <th class="titulo-table">Cuartos</th>
            <th class="titulo-table">Menores</th>
            <th class="titulo-table">Adultos</th>
            <th class="titulo-table">Extras</th>
          </tr>

          <tr>
            <th class="titulo-table">SGL</th>
            <td class="desc-table"><?php echo $total_sgl; ?></td>
            <td class="desc-table"><?php echo $total_menores_sgl; ?></td>
            <td class="desc-table"><?php echo $total_adultos_sgl; ?></td>
            <td class="desc-table">0</td>
          </tr>

          <tr>
            <th class="titulo-table">DBL</th>
            <td class="desc-table"><?php echo $total_dbl; ?></td>
            <td class="desc-table"><?php echo $total_menores_dbl; ?></td>
            <td class="desc-table"><?php echo $total_adultos_dbl; ?></td>
            <td class="desc-table">0</td>
          </tr>

          <tr>
            <th class="titulo-table">TPL</th>
            <td class="desc-table"><?php echo $total_tpl; ?></td>
            <td class="desc-table"><?php echo $total_menores_tpl; ?></td>
            <td class="desc-table"><?php echo $total_adultos_tpl; ?></td>
            <td class="desc-table">0</td>
          </tr>

          <tr>
            <th class="titulo-table">CPL</th>
            <td class="desc-table"><?php echo $total_cpl; ?></td>
            <td class="desc-table"><?php echo $total_menores_cpl; ?></td>
            <td class="desc-table"><?php echo $total_adultos_cpl; ?></td>
            <td class="desc-table">0</td>
          </tr>
              </table>
      </div>

      <div class="_1-1">
        <table class="table-1">
          <tr>
            <th class="titulo-table">Menores gratis</th>
            <th class="titulo-table">Edades</th>
          </tr>

          <tr>
            <td class="desc-table">0</td>
            <td class="desc-table"></td>
          </tr>
              </table>
      </div>
    </article>

    <article style="margin-top: 16px;">
      <div class="_1-1">
        <div class="d-block">
          <div>
            <span class="campo-large">
              Número de confirmación:
            </span>

            <div class="valor-large">
              88255173/88255174/88255
            </div>
          </div>
        </div>
      </div>

      <div class="_1-1">
        <div class="d-block">
          <div>
            <span class="campo-large">
              Persona que confirma
            </span>

            <div class="valor-large">
              Usuario Quality Service test 2023
            </div>
          </div>
        </div>
      </div>
    </article>

    <article class="politicas">
      <p class="texto-politicas">
        <b>Políticas de Cancelacion:</b> De manera general, la política de cancelación de hoteles aplica de la siguiente manera: Cancelaciones hechas 15 días o más antes de la fecha de llegada aplica un cargo aprox de 10%. Cancelaciones hechas de 3 a 14 días antes de la fecha de llegada aplica un cargo aprox de dos noches. Cancelaciones hechas a 2 dias o menos antes de la fecha de llegada aplica un cargo de 100%. Estas políticas de cancelación pueden variar dependiendo la época del año. Puedes revisar la política específica que aplica al hotel que quieres reservar durante el proceso de reservación. En caso de cancelacion de reservas en temporada Alta y Dias festivos, los dias de anticipacion para realizarla aumentan aprox 15 dias con respecto a las politicas de cancelacion en fechas ordinarias. En caso de que tengas que irte del hotel antes de que termine tu estancia (salida anticipada), o no te presentes al hotel (conocido como no show) se considera como cancelación y no aplican reembolsos. Si reduces el número de huéspedes una vez pagada la reservación, es decisión del hotel aplicar penalidades o reembolsos.
      </p>
    </article>
  </section>

  <script>
    function imprimirTicket() {
      // Verifica si el navegador soporta la impresión
      if (window.print) {
        // Llamada a la función de impresión del navegador
        window.print();
      } else {
        alert("Tu navegador no admite la impresión.");
      }
    }
  </script>
</body>
</html>
  <?php }else{ echo "No hay información para mostrar."; } ?>